<?php

namespace App\Test\Controller;

use App\Entity\BioAuthHistory;
use App\Repository\BioAuthHistoryRepository;
use Symfony\Bundle\FrameworkBundle\KernelBrowser;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

class BioAuthHistoryControllerTest extends WebTestCase
{
    private KernelBrowser $client;
    private BioAuthHistoryRepository $repository;
    private string $path = '/bio/auth/history/';

    protected function setUp(): void
    {
        $this->client = static::createClient();
        $this->repository = (static::getContainer()->get('doctrine'))->getRepository(BioAuthHistory::class);

        foreach ($this->repository->findAll() as $object) {
            $this->repository->remove($object, true);
        }
    }

    public function testIndex(): void
    {
        $crawler = $this->client->request('GET', $this->path);

        self::assertResponseStatusCodeSame(200);
        self::assertPageTitleContains('BioAuthHistory index');

        // Use the $crawler to perform additional assertions e.g.
        // self::assertSame('Some text on the page', $crawler->filter('.p')->first());
    }

    public function testNew(): void
    {
        $originalNumObjectsInRepository = count($this->repository->findAll());

        $this->markTestIncomplete();
        $this->client->request('GET', sprintf('%snew', $this->path));

        self::assertResponseStatusCodeSame(200);

        $this->client->submitForm('Save', [
            'bio_auth_history[transactionReference]' => 'Testing',
            'bio_auth_history[status]' => 'Testing',
            'bio_auth_history[dateCreated]' => 'Testing',
            'bio_auth_history[httpRemoteIp]' => 'Testing',
            'bio_auth_history[remotePort]' => 'Testing',
            'bio_auth_history[remoteAdress]' => 'Testing',
            'bio_auth_history[httpUserAgent]' => 'Testing',
            'bio_auth_history[geoipLongitude]' => 'Testing',
            'bio_auth_history[geoipLatitude]' => 'Testing',
            'bio_auth_history[geoipAreaCode]' => 'Testing',
            'bio_auth_history[geoipDmaCode]' => 'Testing',
            'bio_auth_history[geoipCity]' => 'Testing',
            'bio_auth_history[geoipRegion]' => 'Testing',
            'bio_auth_history[geoipCountryName]' => 'Testing',
            'bio_auth_history[geoipCountryCode]' => 'Testing',
            'bio_auth_history[uniqueId]' => 'Testing',
            'bio_auth_history[mac]' => 'Testing',
            'bio_auth_history[bioAuth]' => 'Testing',
        ]);

        self::assertResponseRedirects('/bio/auth/history/');

        self::assertSame($originalNumObjectsInRepository + 1, count($this->repository->findAll()));
    }

    public function testShow(): void
    {
        $this->markTestIncomplete();
        $fixture = new BioAuthHistory();
        $fixture->setTransactionReference('My Title');
        $fixture->setStatus('My Title');
        $fixture->setDateCreated('My Title');
        $fixture->setHttpRemoteIp('My Title');
        $fixture->setRemotePort('My Title');
        $fixture->setRemoteAdress('My Title');
        $fixture->setHttpUserAgent('My Title');
        $fixture->setGeoipLongitude('My Title');
        $fixture->setGeoipLatitude('My Title');
        $fixture->setGeoipAreaCode('My Title');
        $fixture->setGeoipDmaCode('My Title');
        $fixture->setGeoipCity('My Title');
        $fixture->setGeoipRegion('My Title');
        $fixture->setGeoipCountryName('My Title');
        $fixture->setGeoipCountryCode('My Title');
        $fixture->setUniqueId('My Title');
        $fixture->setMac('My Title');
        $fixture->setBioAuth('My Title');

        $this->repository->add($fixture, true);

        $this->client->request('GET', sprintf('%s%s', $this->path, $fixture->getId()));

        self::assertResponseStatusCodeSame(200);
        self::assertPageTitleContains('BioAuthHistory');

        // Use assertions to check that the properties are properly displayed.
    }

    public function testEdit(): void
    {
        $this->markTestIncomplete();
        $fixture = new BioAuthHistory();
        $fixture->setTransactionReference('My Title');
        $fixture->setStatus('My Title');
        $fixture->setDateCreated('My Title');
        $fixture->setHttpRemoteIp('My Title');
        $fixture->setRemotePort('My Title');
        $fixture->setRemoteAdress('My Title');
        $fixture->setHttpUserAgent('My Title');
        $fixture->setGeoipLongitude('My Title');
        $fixture->setGeoipLatitude('My Title');
        $fixture->setGeoipAreaCode('My Title');
        $fixture->setGeoipDmaCode('My Title');
        $fixture->setGeoipCity('My Title');
        $fixture->setGeoipRegion('My Title');
        $fixture->setGeoipCountryName('My Title');
        $fixture->setGeoipCountryCode('My Title');
        $fixture->setUniqueId('My Title');
        $fixture->setMac('My Title');
        $fixture->setBioAuth('My Title');

        $this->repository->add($fixture, true);

        $this->client->request('GET', sprintf('%s%s/edit', $this->path, $fixture->getId()));

        $this->client->submitForm('Update', [
            'bio_auth_history[transactionReference]' => 'Something New',
            'bio_auth_history[status]' => 'Something New',
            'bio_auth_history[dateCreated]' => 'Something New',
            'bio_auth_history[httpRemoteIp]' => 'Something New',
            'bio_auth_history[remotePort]' => 'Something New',
            'bio_auth_history[remoteAdress]' => 'Something New',
            'bio_auth_history[httpUserAgent]' => 'Something New',
            'bio_auth_history[geoipLongitude]' => 'Something New',
            'bio_auth_history[geoipLatitude]' => 'Something New',
            'bio_auth_history[geoipAreaCode]' => 'Something New',
            'bio_auth_history[geoipDmaCode]' => 'Something New',
            'bio_auth_history[geoipCity]' => 'Something New',
            'bio_auth_history[geoipRegion]' => 'Something New',
            'bio_auth_history[geoipCountryName]' => 'Something New',
            'bio_auth_history[geoipCountryCode]' => 'Something New',
            'bio_auth_history[uniqueId]' => 'Something New',
            'bio_auth_history[mac]' => 'Something New',
            'bio_auth_history[bioAuth]' => 'Something New',
        ]);

        self::assertResponseRedirects('/bio/auth/history/');

        $fixture = $this->repository->findAll();

        self::assertSame('Something New', $fixture[0]->getTransactionReference());
        self::assertSame('Something New', $fixture[0]->getStatus());
        self::assertSame('Something New', $fixture[0]->getDateCreated());
        self::assertSame('Something New', $fixture[0]->getHttpRemoteIp());
        self::assertSame('Something New', $fixture[0]->getRemotePort());
        self::assertSame('Something New', $fixture[0]->getRemoteAdress());
        self::assertSame('Something New', $fixture[0]->getHttpUserAgent());
        self::assertSame('Something New', $fixture[0]->getGeoipLongitude());
        self::assertSame('Something New', $fixture[0]->getGeoipLatitude());
        self::assertSame('Something New', $fixture[0]->getGeoipAreaCode());
        self::assertSame('Something New', $fixture[0]->getGeoipDmaCode());
        self::assertSame('Something New', $fixture[0]->getGeoipCity());
        self::assertSame('Something New', $fixture[0]->getGeoipRegion());
        self::assertSame('Something New', $fixture[0]->getGeoipCountryName());
        self::assertSame('Something New', $fixture[0]->getGeoipCountryCode());
        self::assertSame('Something New', $fixture[0]->getUniqueId());
        self::assertSame('Something New', $fixture[0]->getMac());
        self::assertSame('Something New', $fixture[0]->getBioAuth());
    }

    public function testRemove(): void
    {
        $this->markTestIncomplete();

        $originalNumObjectsInRepository = count($this->repository->findAll());

        $fixture = new BioAuthHistory();
        $fixture->setTransactionReference('My Title');
        $fixture->setStatus('My Title');
        $fixture->setDateCreated('My Title');
        $fixture->setHttpRemoteIp('My Title');
        $fixture->setRemotePort('My Title');
        $fixture->setRemoteAdress('My Title');
        $fixture->setHttpUserAgent('My Title');
        $fixture->setGeoipLongitude('My Title');
        $fixture->setGeoipLatitude('My Title');
        $fixture->setGeoipAreaCode('My Title');
        $fixture->setGeoipDmaCode('My Title');
        $fixture->setGeoipCity('My Title');
        $fixture->setGeoipRegion('My Title');
        $fixture->setGeoipCountryName('My Title');
        $fixture->setGeoipCountryCode('My Title');
        $fixture->setUniqueId('My Title');
        $fixture->setMac('My Title');
        $fixture->setBioAuth('My Title');

        $this->repository->add($fixture, true);

        self::assertSame($originalNumObjectsInRepository + 1, count($this->repository->findAll()));

        $this->client->request('GET', sprintf('%s%s', $this->path, $fixture->getId()));
        $this->client->submitForm('Delete');

        self::assertSame($originalNumObjectsInRepository, count($this->repository->findAll()));
        self::assertResponseRedirects('/bio/auth/history/');
    }
}
